<?php

automatic_feed_links();

add_theme_support('post-thumbnails');

if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

    register_sidebar(array(
		'name' => 'Contact Us',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'People',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Academics',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Facilities',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Events',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Field Work',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Alumni',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Footer Contact',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));

	register_sidebar(array(
		'name' => 'Footer Chair',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<span>',
		'after_title' => '</span>',
	));
}

if (function_exists('add_theme_support')) {
    add_theme_support('menus');
}

function divider() {
	return '<div style="clear:both;"></div><hr /><div style="clear:both;"></div>';
}
add_shortcode('divider', 'divider');

function line_space() {
	return '<div style="clear:both;"></div>';
}
add_shortcode('line_space', 'line_space');

function members($atts, $content = null) {
	return '<div class="facultyMembersList">'.do_shortcode($content).'</div>';
}
add_shortcode('members', 'members'); 

function staffbox($atts, $content = null) {
	extract( shortcode_atts(array(
		'name' => '', 
		'member_image' => '',
                'twitter' => '',
		'facebook' => '',
		'linkedin' => '',
		'email' => '',
		), $atts));
	
		if(empty($twitter)) {
			$tsocial='';
		} else {
			$tsocial='<a href="'.$twitter.'" class="twitterLogo"></a>';
		}
		if(empty($facebook)) {
			$fsocial='';
		} else {
			$fsocial='<a href="'.$facebook.'" class="facebookLogo"></a>';
		}
		if(empty($linkedin)) {
			$linkedsocial='';
		} else {
			$linkedsocial='<a href="'.$linkedin.'" class="linkedinLogo"></a>';
		}

	return '<div class="memberBox" ><img src="'.$member_image.'" alt="" width="140" height="136"/><div class="memberBoxTitle">'.$name.'</div><span>'.do_shortcode($content).'<br /><a href="mailto:'.$email.'">Email</a></span><div class="membersSocials">'.$tsocial.''.$fsocial.''.$linkedsocial.'</div></div>';
}
add_shortcode('staffbox', 'staffbox');

function staffbox_last($atts, $content = null) {
	extract( shortcode_atts(array(
		'name' => '', 
		'member_image' => '',
        'twitter' => '',
		'facebook' => '',
		'email' => '',
		), $atts));
	
		if(empty($twitter)) {
			$tsocial='';
		} else {
			$tsocial='<a href="'.$twitter.'" class="twitterLogo"></a>';
		}
		if(empty($facebook)) {
			$fsocial='';
		} else {
			$fsocial='<a href="'.$facebook.'" class="facebookLogo"></a>';
		}
		if(empty($linkedin)) {
			$linkedsocial='';
		} else {
			$linkedsocial='<a href="'.$linkedin.'" class="linkedinLogo"></a>';
		}

	return '<div class="memberBox notMarginRight" ><img src="'.$member_image.'" alt="" width="140" height="136"/><div class="memberBoxTitle">'.$name.'</div><span>'.do_shortcode($content).'<br /><a href="mailto:'.$email.'">Email</a></span><div class="membersSocials">'.$tsocial.''.$fsocial.''.$linkedsocial.'</div></div>';
}
add_shortcode('staffbox_last', 'staffbox_last');

function grad($atts, $content = null) {
	extract( shortcode_atts(array(
		'name' => '',
		'email' => '',
		'ms' => 'false',
		'phd' => 'false',
		'phds' => 'false',
		'advisors' => '',
		'group' => '',
		), $atts));
		if($ms == 'false') {
			$ms="";
		}  else {
		    $ms="<i>MS Student</i><br />";
		}
		if($phd == 'false') {
			$phd="";
		} else {
			$phd="<i>PhD Candidate</i><br>";
		}
		if($phds == 'false') {
			$phds="";
		} else {
			$phds="<i>PhD Student</i><br>";
		}


	return '<div class="memberBox" ><div class="memberBoxTitle">'.$name.'</div><span>'.$ms.''.$phd.''.$phds.''.$group.''.do_shortcode($content).'<br>Advisor: '.$advisors.'<br /><a href="mailto:'.$email.'">Email</a></span></div>';
}
add_shortcode('grad', 'grad');

function the_titlesmall($before = '', $after = '', $echo = true, $length = false) { $title = get_the_title();

	if ( $length && is_numeric($length) ) {
		$title = substr( $title, 0, $length );
	}

	if ( strlen($title)> 0 ) {
		$title = apply_filters('the_titlesmall', $before . $title . $after, $before, $after);
		if ( $echo )
			echo $title;
		else
			return $title;
	}
}
// Add support for flexible headers
 $header_args = array(
 'flex-height' => true,
 'height' => 183,
 'flex-width' => true,
 'width' => 680,
 'default-image' => get_template_directory_uri() . '/images/header.jpg',
// 'admin-head-callback' => 'mytheme_admin_header_style',
 );

 add_theme_support( 'custom-header', $header_args );
?>
